setwd("~/MMM/projects/2024 AOGA remand")
#April 1,2025
#updated the min/max TAD using new input for den function
#using newly updated probabilities for input to disturbance function
#dev didn't change, so kept old dev files to save a lot of time

library(sf)
library(raster)
library(maptools)
library(spatstat)
library(ald)
library(maptools)
library(foreach)
library(doParallel)
library(stringi) #used to manipulate Sys.time() for appending to output file names

setwd("~/MMM/projects/2024 AOGA remand/den disturbance files for record MAR2025") #CHANGE THIS to the directory containing the files

long.years = c("2021-2022","2022-2023","2023-2024","2024-2025","2025-2026")
short.years = c("2122","2223","2324","2425","2526")


load("~/MMM/projects/000 common files for den analyses/helper_objects_V5.2_,20240925_114930.067491.RData")

source("~/MMM/projects/2024 AOGA remand/den.func.parallel.remand.R", echo=TRUE) #use updated den function so we can use TAD between .5 and 22.5 (per Eric's data)
#this den function has a different name to not overwrite the default (it will eventually be part of new releases)

dev.path="" # this is the common directory for where development objects are stored (or their sub directories) can also hard code below if needed
out.path="" #this can be used if you want the out.path to be in a different folder
# if (! dir.exists(out.path) ) dir.create(out.path) #create an output folder if doesn't exist

######################################
######################################
#Simulate dens
######################################


#Simulate a set of simulated dens for use in disturbance function
library(foreach)
library(doParallel)

if(0) #only need to generate once, so put inside loop that won't execute when sourcing the script 
  {    
  
  for (e.y in 2022:2026){  
    print(Sys.time())
    writeLines(paste("starting den sim for emergence year",e.y))
    print(Sys.time())
    
    n.sim =10000
    {
      temp.time=Sys.time()
      cl <- makePSOCKcluster(detectCores()-1)#  15)
      registerDoParallel(cl)
      sim.dens=vector()
      sim.dens=foreach(i=1:n.sim,.packages=c("raster","maptools","spatstat","ald"),.errorhandling='pass',.verbose=F,.multicombine=TRUE) %dopar%
        # den.func.parallel(emerg.year=e.y)
      den.func.parallel.remand(emerg.year=e.y,time.at.den= c(7.65,7.25),time.at.den.range = c(.5,22.5)) #per Ryan: mean(t.a.d)=7.65; sd(t.a.d)=7.25, using Eric's range for TAD cutoffs
      
      stopCluster(cl)
      print(Sys.time()-temp.time)
    }
    saveRDS(sim.dens,paste0(out.path,"sim.dens",e.y-1,"-",e.y,"_", insert.time(), ".rds"))
  }#for (e.y)  
}

list.files(pattern = "sim.dens2025*.*\\.rds$") #list any den files in output folder
# list.files(path=out.path,pattern = "sim.dens2025*.*\\.rds$") #list any den files in output folder, use this version if you specified and out.path value
# [1] "sim.dens2021-2022_20250401_133739.471385.rds" "sim.dens2022-2023_20250401_135306.75184.rds" 
# [3] "sim.dens2023-2024_20250401_140833.996896.rds" "sim.dens2024-2025_20250401_142352.904362.rds"
# [5] "sim.dens2025-2026_20250401_143944.80026.rds" 


#use dens already simulated
sim.dens2122 = readRDS("sim.dens2021-2022_20250401_133739.471385.rds")
sim.dens2223 = readRDS("sim.dens2022-2023_20250401_135306.75184.rds")
sim.dens2324 = readRDS("sim.dens2023-2024_20250401_140833.996896.rds")
sim.dens2425 = readRDS("sim.dens2024-2025_20250401_142352.904362.rds")
sim.dens2526 = readRDS("sim.dens2025-2026_20250401_143944.80026.rds")

############################
############################
#read in development data
######################################
#read coastline (used in plotting)
ak.coast  = st_read("~/MMM/projects/000 common files for den analyses/AK coast/ak_coast63k_aa154n83_Line_Ncoast.shp")
ak.coast = st_zm(ak.coast) #drop 3rd dimension as we don't need it (won't do anything if already 2d)
ak.coast = st_transform(ak.coast,akproj)


if(0){ #will be reading in already created development objects, so no need to run again unless rebuilding files
  

dev.layers = st_layers("Remand_Analysis_Files.gdb") #gives info on features within the GDB
# Available layers:
#                   layer_name                 geometry_type         features fields                                 crs_name
# 1        AOGAITRRoads_Master_21Dec23 3D Measured Multi Line String     2046     79                 NAD83(2011) / Alaska Albers
# 2     AOGAITRPipeline_Master_21Dec23 3D Measured Multi Line String     1291     80                 NAD83(2011) / Alaska Albers
# 3          Coastal_ITR_Area_AKAlbers              3D Multi Polygon        1      2                 NAD83(2011) / Alaska Albers
# 4           Inland_ITR_Area_AKAlbers              3D Multi Polygon        1      3                 NAD83(2011) / Alaska Albers
# 5                       Seismic_2122                 Multi Polygon        1      6                 NAD83(2011) / Alaska Albers
# 6         badami_pl_plus_PTUresupply 3D Measured Multi Line String        9     79                 NAD83(2011) / Alaska Albers
# 7               generic_seismic_area                 Multi Polygon        1     10                       NAD83 / Alaska Albers
# 8         Pipeline_for_3rd_Seis_FLIR 3D Measured Multi Line String        8     79                 NAD83(2011) / Alaska Albers
# 9                       Seismic_2324     3D Measured Multi Polygon        2     78                 NAD83(2011) / Alaska Albers
# 10    Piston_Bully_3_Route_Feb_11_13 3D Measured Multi Line String        1      4                           WGS 84 + WGS_1984
# 11                       PT_Trail_22 3D Measured Multi Line String        1      4                           WGS 84 + WGS_1984
# 12             Bullen_Pt_Staging_Pad                         Point        1     11 NAD_1983_StatePlane_Alaska_4_FIPS_5004_Feet
# 13 Proposed_Additional_Tundra_Travel             Multi Line String        1      7 NAD_1983_StatePlane_Alaska_3_FIPS_5003_Feet
# 14 AOGAITRPads_Master_23Feb24_woseis     3D Measured Multi Polygon      581     87                 NAD83(2011) / Alaska Albers
 
dev.layers.names = dev.layers$name

# [1] "AOGAITRPads_Master_23Feb24_woseis" "AOGAITRRoads_Master_21Dec23"       "AOGAITRPipeline_Master_21Dec23"    "Coastal_ITR_Area_AKAlbers"        
# [5] "Inland_ITR_Area_AKAlbers"          "Seismic_2122"                      "badami_pl_plus_PTUresupply"        "generic_seismic_area"             
# [9] "Pipeline_for_3rd_Seis_FLIR"        "Seismic_2324"                      "Piston_Bully_3_Route_Feb_11_13"    "PT_Trail_22"                      
# [13] "Bullen_Pt_Staging_Pad"             "Proposed_Additional_Tundra_Travel"


 for (i in 1:length(dev.layers.names)){
  if (dev.layers.names[i] == "PT_Trail_22") next      #Please remove PT_Trail_22. The use of that trail was actually outside of their LOA and not authorized. (per Stephanie)
  
  start.stop.names = c("start21","end22","start22","end23","start23","end24","start24","end25","start25","end26")  #names of all columns needed for start/stop date info
  if(dev.layers$fields[i] < 12)  start.stop.names = NULL #some of the features had no start stop info, so read in without and add manually later if necessary
  #use the original layer names and assign the feature info to that name
  assign(dev.layers.names[i] , import.shapefile(shape.dir ="", file.name = "Remand_Analysis_Files.gdb", 
                                                layer.name = dev.layers.names[i], start.stop.names = start.stop.names  )  )
}#end for i          


#check names dates for those with imported dates (hopefully they match!) 
names(AOGAITRPads_Master_23Feb24_woseis[[3]])
names(AOGAITRRoads_Master_21Dec23[[3]])
names(AOGAITRPipeline_Master_21Dec23[[3]])
names(badami_pl_plus_PTUresupply[[3]])
names(Pipeline_for_3rd_Seis_FLIR[[3]])
names(Seismic_2324[[3]])


#add in start stop dates as needed:
{
# generic_seismic_area is what we ran in the ITR: Jan 1 -April 15
# Seismic 2122: Jan 1-May 15
# Proposed_Additional_Tundra_Travel: 03/01/-04/30
# Piston_Bully_3_Route_Feb_11_13 should be 01/20-05/15. This route was NOT FLIRed.
# Bullen_Pt_Staging_Pad: 03/01-04/30

# length(AOGAITRPads_Master_23Feb24_woseis[[2]])

n.NA = rep(NA,length(generic_seismic_area[[2]])) #notreally necessary in this case, but this will work when more than one element in feature and they all get same
tmp.dates = data.frame(start21=n.NA,end22=n.NA,start22=n.NA,end23=n.NA,start23=n.NA,end24=n.NA,start24=n.NA,end25=n.NA,start25=n.NA,end26=n.NA)
tmp.dates[,7:8] = c("1-1-25","4-15-25")
tmp.dates[,9:10] = c("1-1-26","4-15-26")
tmp.dates  = apply(tmp.dates,MARGIN = 2,strptime,'%m-%d-%y') #convert to POSIXlt
generic_seismic_area[[3]] = as.data.frame(tmp.dates)

n.NA = rep(NA,length(Seismic_2122[[2]]))
tmp.dates = data.frame(start21=n.NA,end22=n.NA,start22=n.NA,end23=n.NA,start23=n.NA,end24=n.NA,start24=n.NA,end25=n.NA,start25=n.NA,end26=n.NA)
tmp.dates[,1:2] = c("1-1-22","5-15-22")
tmp.dates  = apply(tmp.dates,MARGIN = 2,strptime,'%m-%d-%y') #convert to POSIXlt
Seismic_2122[[3]] = as.data.frame(tmp.dates)

n.NA = rep(NA,length(Proposed_Additional_Tundra_Travel[[2]]))
tmp.dates = data.frame(start21=n.NA,end22=n.NA,start22=n.NA,end23=n.NA,start23=n.NA,end24=n.NA,start24=n.NA,end25=n.NA,start25=n.NA,end26=n.NA)
tmp.dates[,1:2] = c("3-1-22","4-30-22")
tmp.dates  = apply(tmp.dates,MARGIN = 2,strptime,'%m-%d-%y') #convert to POSIXlt
Proposed_Additional_Tundra_Travel[[3]] = as.data.frame(tmp.dates)

n.NA = rep(NA,length(Piston_Bully_3_Route_Feb_11_13[[2]]))
tmp.dates = data.frame(start21=n.NA,end22=n.NA,start22=n.NA,end23=n.NA,start23=n.NA,end24=n.NA,start24=n.NA,end25=n.NA,start25=n.NA,end26=n.NA)
tmp.dates[,1:2] = c("1-20-22","5-15-22")
tmp.dates  = apply(tmp.dates,MARGIN = 2,strptime,'%m-%d-%y') #convert to POSIXlt
Piston_Bully_3_Route_Feb_11_13[[3]] = as.data.frame(tmp.dates)

n.NA = rep(NA,length(Bullen_Pt_Staging_Pad[[2]]))
tmp.dates = data.frame(start21=n.NA,end22=n.NA,start22=n.NA,end23=n.NA,start23=n.NA,end24=n.NA,start24=n.NA,end25=n.NA,start25=n.NA,end26=n.NA)
tmp.dates[,1:2] = c("3-1-22","4-30-22")
tmp.dates  = apply(tmp.dates,MARGIN = 2,strptime,'%m-%d-%y') #convert to POSIXlt
Bullen_Pt_Staging_Pad[[3]] = as.data.frame(tmp.dates)

#########################
#double check date matrices for manually added objects
generic_seismic_area[[3]]
Seismic_2122[[3]]
Proposed_Additional_Tundra_Travel[[3]]
Piston_Bully_3_Route_Feb_11_13[[3]]
Bullen_Pt_Staging_Pad[[3]]
}

#merge all the objects into a single object
AOGA.all.dev = merge.dev.objects(AOGAITRPads_Master_23Feb24_woseis, AOGAITRRoads_Master_21Dec23, AOGAITRPipeline_Master_21Dec23,
                                 Seismic_2122, badami_pl_plus_PTUresupply, generic_seismic_area, Pipeline_for_3rd_Seis_FLIR, Seismic_2324)

# #make sure all dev dates are in correct columns
# range(AOGA.all.dev[[3]][,1],na.rm = T)
 
#check if any have start with no end and vice versa
AOGA.all.dev[[3]] [(is.na(AOGA.all.dev[[3]][,7]) & !is.na(AOGA.all.dev[[3]][,8])) | (!is.na(AOGA.all.dev[[3]][,7]) & is.na(AOGA.all.dev[[3]][,8])) , ]

boundingbox(AOGA.all.dev[[1]]) #get bounding box, perhaps to use with plots
# window: rectangle = [43181.9, 338330.9] x [2223711.1, 2315334.9] units
bbox.x = c(43181.9, 338330.9)
bbox.y = c(2223711.1, 2315334.9)


#check dimensions to match AOGA.all.dev
sum(
length(AOGAITRPads_Master_23Feb24_woseis[[2]]),
length(AOGAITRRoads_Master_21Dec23[[2]]),
length(AOGAITRPipeline_Master_21Dec23[[2]]),
length(Seismic_2122[[2]]),
length(badami_pl_plus_PTUresupply[[2]]),
length(generic_seismic_area[[2]]),
length(Pipeline_for_3rd_Seis_FLIR[[2]]),
length(Seismic_2324[[2]])
)

length(AOGA.all.dev[[2]])


#pull and compact dev for each emergence year

AOGA.2122.dev = combine.compact.feature(AOGA.all.dev,start.col=1)
AOGA.2223.dev = combine.compact.feature(AOGA.all.dev,start.col=3)
AOGA.2324.dev = combine.compact.feature(AOGA.all.dev,start.col=5)
AOGA.2425.dev = combine.compact.feature(AOGA.all.dev,start.col=7)
AOGA.2526.dev = combine.compact.feature(AOGA.all.dev,start.col=9)

##########################
##########################
#generate FLIR data
##########################

#in ALL years                        #2 FLIR: 12/1-12-25; 12/15-1/10
# "AOGAITRPads_Master_23Feb24_woseis" 
# "AOGAITRRoads_Master_21Dec23"       
# "AOGAITRPipeline_Master_21Dec23"  

FLIR.owin.allyears      = merge.dev.objects(AOGAITRPads_Master_23Feb24_woseis, AOGAITRRoads_Master_21Dec23, AOGAITRPipeline_Master_21Dec23)
FLIR.dates.allyears = data.frame(start = c(strptime('2021-12-01','%Y-%m-%d'),strptime('2021-12-25','%Y-%m-%d')),
                                 end   = c(strptime('2021-12-15','%Y-%m-%d'),strptime('2022-01-10','%Y-%m-%d')))

################
#in 2122 
# "Seismic_2122"                      #3 FLIR: 11/25-12/15; 12/5-12/31; 12/15-1/15 
# "Pipeline_for_3rd_Seis_FLIR"        #3 FLIR: 12/1-12/25;  12/15-1/10; 12/15-1/10
# "Bullen_Pt_Staging_Pad"             #2 FLIR: 12/1-12-25;  12/15-1/10
# "Proposed_Additional_Tundra_Travel" #2 FLIR: 12/1-12-25;  12/15-1/10
# "Piston_Bully_3_Route_Feb_11_13"    #2 FLIR: 12/1-12-25;  12/15-1/10

#start with all year elements
FLIR.common.2122 = combine.compact.feature(FLIR.owin.allyears,start.col=1)
FLIR.common.2122.buff = do.call(union.owin, unname(FLIR.common.2122[[4]])) #get buffered common elements
FLIR.owin.list.2122 = list(FLIR.common.2122.buff,FLIR.common.2122.buff) #will be flired twice
FLIR.dates.2122     = FLIR.dates.allyears
  
#add with those having common times
tmp      = merge.dev.objects(Bullen_Pt_Staging_Pad, Proposed_Additional_Tundra_Travel,Piston_Bully_3_Route_Feb_11_13)[[1]] #starting with those having common times
tmp.buff = expand.owin(tmp,distance = disturbance.distance)
FLIR.owin.list.2122 = append(FLIR.owin.list.2122,list(tmp.buff,tmp.buff))  #two sessions, so need owin for each session  
FLIR.dates.2122     = rbind(FLIR.dates.2122,
                            data.frame(start = c(strptime('2021-12-01','%Y-%m-%d'),strptime('2021-12-25','%Y-%m-%d')),
                                 end   = c(strptime('2021-12-15','%Y-%m-%d'),strptime('2022-01-10','%Y-%m-%d'))) )

#add Seismic_2122
tmp.buff = expand.owin(Seismic_2122[[1]],distance = disturbance.distance)
FLIR.owin.list.2122 = append(FLIR.owin.list.2122,list(tmp.buff,tmp.buff,tmp.buff))
FLIR.dates.2122     =rbind(FLIR.dates.2122,data.frame(start = c(strptime('2021-11-25','%Y-%m-%d'),strptime('2021-12-5' ,'%Y-%m-%d'),strptime('2021-12-15','%Y-%m-%d')),
                                                      end   = c(strptime('2021-12-15','%Y-%m-%d'),strptime('2021-12-31','%Y-%m-%d'),strptime('2022-1-15' ,'%Y-%m-%d'))))
#add flir on Pipeline_for_3rd_Seis_FLIR
tmp.buff = expand.owin(Pipeline_for_3rd_Seis_FLIR[[1]],distance = disturbance.distance)
FLIR.owin.list.2122 = append(FLIR.owin.list.2122,list(tmp.buff,tmp.buff,tmp.buff))
FLIR.dates.2122     = rbind(FLIR.dates.2122,data.frame(start = c(strptime('2021-12-01','%Y-%m-%d'),strptime('2021-12-25','%Y-%m-%d'),strptime('2021-12-25','%Y-%m-%d')),
                                                      end   = c(strptime('2021-12-15','%Y-%m-%d'),strptime('2022-01-10','%Y-%m-%d'),strptime('2022-01-10','%Y-%m-%d'))))

################
#in 22-23
# "badami_pl_plus_PTUresupply"        #3 FLIR: 12/1-12/25; 12/15-1/10; 12/15-1/10  

#start with all year elements
FLIR.common.2223 = combine.compact.feature(FLIR.owin.allyears,start.col=3)
FLIR.common.2223.buff = do.call(union.owin, unname(FLIR.common.2223[[4]])) #get buffered common elements
FLIR.owin.list.2223 = list(FLIR.common.2223.buff,FLIR.common.2223.buff) #will be flired twice
FLIR.dates.2223     = FLIR.dates.allyears  + (365*24*3600) #add a year to allyears dates

#add in badami_pl_plus_PTUresupply
tmp.buff = expand.owin(badami_pl_plus_PTUresupply[[1]],distance = disturbance.distance)
FLIR.owin.list.2223 = append(FLIR.owin.list.2223,list(tmp.buff,tmp.buff,tmp.buff))
FLIR.dates.2223     = rbind(FLIR.dates.2223,data.frame(start = c(strptime('2022-12-01','%Y-%m-%d'),strptime('2022-12-15','%Y-%m-%d'),strptime('2022-12-15','%Y-%m-%d')),
                                                       end   = c(strptime('2022-12-25','%Y-%m-%d'),strptime('2023-01-10','%Y-%m-%d'),strptime('2023-01-10','%Y-%m-%d'))))



################
#in 23-24
# "Seismic_2324"                      #3 FLIR: 11/25-12/15; 12/5-12/31; 12/15-1/15
# "Pipeline_for_3rd_Seis_FLIR"        #3 FLIR: 12/1-12/25;  12/15-1/10; 12/15-1/10
#start with all year elements
FLIR.common.2324 = combine.compact.feature(FLIR.owin.allyears,start.col=5)
FLIR.common.2324.buff = do.call(union.owin, unname(FLIR.common.2324[[4]])) #get buffered common elements
FLIR.owin.list.2324 = list(FLIR.common.2324.buff,FLIR.common.2324.buff) #will be flired twice
FLIR.dates.2324     = FLIR.dates.allyears+ (365*24*3600)*2  #add 2 years to allyears dates

#add Seismic_2324
tmp.buff = expand.owin(Seismic_2324[[1]],distance = disturbance.distance)
FLIR.owin.list.2324 = append(FLIR.owin.list.2324,list(tmp.buff,tmp.buff,tmp.buff))
FLIR.dates.2324     =rbind(FLIR.dates.2324,data.frame(start = c(strptime('2023-11-25','%Y-%m-%d'),strptime('2023-12-5' ,'%Y-%m-%d'),strptime('2023-12-15','%Y-%m-%d')),
                                                      end   = c(strptime('2023-12-15','%Y-%m-%d'),strptime('2023-12-31','%Y-%m-%d'),strptime('2024-1-15' ,'%Y-%m-%d'))))
#add in Pipeline_for_3rd_Seis_FLIR
tmp.buff = expand.owin(Pipeline_for_3rd_Seis_FLIR[[1]],distance = disturbance.distance)
FLIR.owin.list.2324 = append(FLIR.owin.list.2324,list(tmp.buff,tmp.buff,tmp.buff))
FLIR.dates.2324     = rbind(FLIR.dates.2324,data.frame(start = c(strptime('2023-12-01','%Y-%m-%d'),strptime('2023-12-15','%Y-%m-%d'),strptime('2023-12-15','%Y-%m-%d')),
                                                       end   = c(strptime('2023-12-25','%Y-%m-%d'),strptime('2024-01-10','%Y-%m-%d'),strptime('2024-01-10','%Y-%m-%d'))))


################
#in 24-25  and 25-26
# "generic_seismic_area"              #3 FLIR: 11/25-12/15; 12/5-12/31; 12/15-1/15

#start with all year elements
FLIR.common.2425 = combine.compact.feature(FLIR.owin.allyears,start.col=7)
FLIR.common.2425.buff = do.call(union.owin, unname(FLIR.common.2425[[4]])) #get buffered common elements
FLIR.owin.list.2425 = list(FLIR.common.2425.buff,FLIR.common.2425.buff) #will be flired twice
FLIR.dates.2425     = FLIR.dates.allyears+ (365*24*3600)*3 + 24*3600 #add 3 years to allyears dates, have to also account for a leap year

#add generic_seismic_area
tmp.buff = expand.owin(generic_seismic_area[[1]],distance = disturbance.distance)
FLIR.owin.list.2425 = append(FLIR.owin.list.2425,list(tmp.buff,tmp.buff,tmp.buff))
FLIR.dates.2425     = rbind(FLIR.dates.2425,data.frame(start = c(strptime('2024-11-25','%Y-%m-%d'),strptime('2024-12-5' ,'%Y-%m-%d'),strptime('2024-12-15','%Y-%m-%d')),
                                                       end   = c(strptime('2024-12-15','%Y-%m-%d'),strptime('2024-12-31','%Y-%m-%d'),strptime('2025-1-15' ,'%Y-%m-%d'))))

#25-26 is same, just need to add a year to dates
FLIR.common.2526 = combine.compact.feature(FLIR.owin.allyears,start.col=9)
FLIR.common.2526.buff = do.call(union.owin, unname(FLIR.common.2526[[4]])) #get buffered common elements
FLIR.owin.list.2526 = list(FLIR.common.2526.buff,FLIR.common.2526.buff) #will be flired twice
FLIR.dates.2526     = FLIR.dates.allyears+ (365*24*3600)*4 + 24*3600 #add 4 years to allyears dates, have to also account for a leap year, 
#add generic_seismic_area
#can use temp.buff from above
FLIR.owin.list.2526 = append(FLIR.owin.list.2526,list(tmp.buff,tmp.buff,tmp.buff))
FLIR.dates.2526     = rbind(FLIR.dates.2526,data.frame(start = c(strptime('2025-11-25','%Y-%m-%d'),strptime('2025-12-5' ,'%Y-%m-%d'),strptime('2025-12-15','%Y-%m-%d')),
                                                       end   = c(strptime('2025-12-15','%Y-%m-%d'),strptime('2025-12-31','%Y-%m-%d'),strptime('2026-1-15' ,'%Y-%m-%d'))))

#add to dev.objects
AOGA.2122.dev = append(AOGA.2122.dev,list(FLIR.owin.list=FLIR.owin.list.2122, FLIR.dates=FLIR.dates.2122, study.area.owin = do.call(union.owin, unname(AOGA.2122.dev$unique.dev.list.buff)) )  )
AOGA.2223.dev = append(AOGA.2223.dev,list(FLIR.owin.list=FLIR.owin.list.2223, FLIR.dates=FLIR.dates.2223, study.area.owin = do.call(union.owin, unname(AOGA.2223.dev$unique.dev.list.buff)) )  )
AOGA.2324.dev = append(AOGA.2324.dev,list(FLIR.owin.list=FLIR.owin.list.2324, FLIR.dates=FLIR.dates.2324, study.area.owin = do.call(union.owin, unname(AOGA.2324.dev$unique.dev.list.buff)) )  )
AOGA.2425.dev = append(AOGA.2425.dev,list(FLIR.owin.list=FLIR.owin.list.2425, FLIR.dates=FLIR.dates.2425, study.area.owin = do.call(union.owin, unname(AOGA.2425.dev$unique.dev.list.buff)) )  )
AOGA.2526.dev = append(AOGA.2526.dev,list(FLIR.owin.list=FLIR.owin.list.2526, FLIR.dates=FLIR.dates.2526, study.area.owin = do.call(union.owin, unname(AOGA.2526.dev$unique.dev.list.buff)) )  )

#save all yearly dev objects
saveRDS(AOGA.2122.dev, paste0(out.path,"AOGA.2122.dev_", insert.time(),  ".rds"))
saveRDS(AOGA.2223.dev, paste0(out.path,"AOGA.2223.dev_", insert.time(),  ".rds"))
saveRDS(AOGA.2324.dev, paste0(out.path,"AOGA.2324.dev_", insert.time(),  ".rds"))
saveRDS(AOGA.2425.dev, paste0(out.path,"AOGA.2425.dev_", insert.time(),  ".rds"))
saveRDS(AOGA.2526.dev, paste0(out.path,"AOGA.2526.dev_", insert.time(),  ".rds"))

}#end if 0

# #if you want to read them back:
AOGA.2122.dev = readRDS(paste0(out.path,list.files(path=out.path,pattern = "AOGA\\.2122\\.dev.*\\.rds$")))
AOGA.2223.dev = readRDS(paste0(out.path,list.files(path=out.path,pattern = "AOGA\\.2223\\.dev.*\\.rds$")))
AOGA.2324.dev = readRDS(paste0(out.path,list.files(path=out.path,pattern = "AOGA\\.2324\\.dev.*\\.rds$")))
AOGA.2425.dev = readRDS(paste0(out.path,list.files(path=out.path,pattern = "AOGA\\.2425\\.dev.*\\.rds$")))
AOGA.2526.dev = readRDS(paste0(out.path,list.files(path=out.path,pattern = "AOGA\\.2526\\.dev.*\\.rds$")))


#################

#plot all the FLIR objects with dates of flir  

#same as above but using AOGA.XXXX.dev objects and done in a loop
for (i in 1:5){
  pdf(paste0(out.path,"Dev.FLIR.plots_",short.years[i],insert.time(), ".pdf"),width = 10,height = 7.5)
  tmp=get(eval(paste0("AOGA.",short.years[i],".dev")))
  plot(tmp[[1]],xlim=bbox.x,ylim=bbox.y,col="black",
       main=paste("AOGA",long.years[i],"development footprint (unbuffered)"))
  plot(ak.coast[,1],col="red",lwd=2,add=T)
  for(i in 1:length(tmp$FLIR.owin.list)){
    plot(tmp$FLIR.owin.list[[i]],col=i+1,xlim=bbox.x,ylim=bbox.y,
         main=paste(long.years[i],"FLIR date",tmp$FLIR.dates[i,1],"to",tmp$FLIR.dates[i,2])); plot(ak.coast[,1],col="black",lwd=2,add=T)}
  dev.off()
}




##########################
##########################
#we now have all the input data available
# can run disturbance sim
library(foreach)
library(doParallel)

#read in den and dev info, presumes only one copy for each emergence year matching the patterns below
dens.vals = c("sim.dens2021.*\\.rds$"     ,"sim.dens2022.*\\.rds$"      ,"sim.dens2023.*\\.rds$"      ,"sim.dens2024.*\\.rds$"      ,"sim.dens2025.*\\.rds$"      )
devs.vals = c("AOGA\\.2122\\.dev.*\\.rds$", "AOGA\\.2223\\.dev.*\\.rds$", "AOGA\\.2324\\.dev.*\\.rds$", "AOGA\\.2425\\.dev.*\\.rds$", "AOGA\\.2526\\.dev.*\\.rds$")
out.vals  = c("sim.dist2122_"             , "sim.dist2223_"             , "sim.dist2324_"             , "sim.dist2425_"             , "sim.dist2526_"             )

for(iii in 3) {  
   cl <- makePSOCKcluster(15) #was throwing errors outside the loop, so put here and also cleanup at end

  sim.dens = readRDS(paste0(out.path,list.files(path=out.path,pattern = dens.vals[iii])))
  list2env(readRDS(paste0(out.path,list.files(path=out.path,pattern = devs.vals[iii]))),globalenv())  #put all elements of returned list into global environment
  names(unique.dev.dates) = c("start","end") #need to not have the years in the name
  {
    temp.time=Sys.time()
    registerDoParallel(cl)
    x=vector()
    x=foreach(i=1:length(sim.dens),.packages=c("raster","maptools","spatstat"),.errorhandling='pass',.verbose=F,.multicombine=TRUE) %dopar%
      disturbance.func.parallel.FLIRvar(dens=sim.dens[[i]],
                                        #probabilities were updated 4/1/25 by Ryan
                                        prob.resp.estab = c( 9/12, 3/12,     0,    0), #c(0.750, 0.250, 0.000, 0.000), None, levB, LevA, Lethal
                                        prob.resp.early = c(12/13,    0,     0, 1/13), #c(0.923, 0.000, 0.000, 0.077), None, LevB, LevA, Lethal
                                        prob.resp.late  = c(26/38,    0, 12/38,    0), #c(0.684, 0.000, 0.316, 0.000), None, LevB, LevA, Lethal
                                        prob.resp.post  = c(    0, 6/19, 13/19,    0), #c(0.000, 0.316, 0.684, 0.000), None, LevB, LevA, Lethal
                                        prob.resp.post2 = c(    0, 8/12,  4/12,    0), #c(0.000, 0.667, 0.333, 0.000), None, LevB, LevA, Lethal#If disturbed during late denning, prob of being disturbed during post emergence
                                        dev.obj          =unique.dev.owin,
                                        dev.obj.list     =unique.dev.list,
                                        dev.obj.list.buff=unique.dev.list.buff, 
                                        dev.obj.dates    =unique.dev.dates,
                                        FLIR.regions     =FLIR.owin.list,
                                        FLIR.dates       =FLIR.dates)
    stopCluster(cl)
    print(Sys.time()-temp.time)
    
    sim.dist=list()
    sim.dist[[1]]=lapply(x,FUN=function(xx) xx[[1]]) #dens
    sim.dist[[2]]=do.call(rbind,lapply(x,FUN = function(xx) xx[[2]])) #disturbance results
    sim.dist[[3]]=lapply(x,FUN = function(xx) xx[[3]]) 
    
  }
  saveRDS(sim.dist,paste0(out.path,out.vals[iii], insert.time(),".rds"))
  env <- foreach:::.foreachGlobals; rm(list=ls(name=env), pos=env); rm(env) #do some cleanup a la https://stackoverflow.com/questions/25097729/un-register-a-doparallel-cluster
} #end for iii



#######################
#######################
#post processing and summary


sink(paste0(out.path,"AOGA Summary Stat output_", insert.time(),".txt"),split=T)#write the output to a file split sends to new sink and current output stream
for(i in 1:5){
  sim.dist = readRDS(paste0(out.path,list.files(path=out.path,pattern = paste0("sim.dist",short.years[i],".*\\.rds$"))))
writeLines(paste("AOGA den disturbance output for",long.years[i] ))
tmp = summary.stats(sim.dist)
print(tmp, row.names = FALSE)
writeLines("\n\n\n")
}


#also need all 5 years together
for(i in 1:5)  assign(paste0("sim.dist",i), readRDS(paste0(out.path,list.files(path=out.path,pattern = paste0("sim.dist",short.years[i],".*\\.rds$")))) )


sim.dist.5yr=list()
#need to make it match original form so we can use the existing summary function:
#[[1]] need to append rows for all

sim.dist.5yr[[1]]=Map(rbind,sim.dist1[[1]]   ,sim.dist2[[1]]) #append each set of dens to the list of dens (ie, 10000 sets of 5 year's of dens)
sim.dist.5yr[[1]]=Map(rbind,sim.dist.5yr[[1]],sim.dist3[[1]]) #note: this doesn't make sense on the survival probs, so ignore those for now
sim.dist.5yr[[1]]=Map(rbind,sim.dist.5yr[[1]],sim.dist4[[1]])
sim.dist.5yr[[1]]=Map(rbind,sim.dist.5yr[[1]],sim.dist5[[1]])

#[[2]] we have added up counts (ignore the survival probs)
sim.dist.5yr[[2]]=as.data.frame(Map('+',sim.dist1[[2]]   ,sim.dist2[[2]]) )#add all the counts together from all 5
sim.dist.5yr[[2]]=as.data.frame(Map('+',sim.dist.5yr[[2]],sim.dist3[[2]]) ) #note: this doesn't make sense on the survival probs, but those are not aggregated in the summary function (pulled from the [[1]] list)
sim.dist.5yr[[2]]=as.data.frame(Map('+',sim.dist.5yr[[2]],sim.dist4[[2]]) )
sim.dist.5yr[[2]]=as.data.frame(Map('+',sim.dist.5yr[[2]],sim.dist5[[2]]) )
#[[3]] DON'T append flir info, can actually ignore for doing summary stats

writeLines(paste("AOGA den disturbance output for all 5 years" ))
tmp = summary.stats(sim.dist.5yr)
print(tmp, row.names = FALSE)
writeLines("\n\n\n")

#also need last 2 years together
sim.dist.2yr=list()
sim.dist.2yr[[1]]=Map(rbind,sim.dist4[[1]]   ,sim.dist5[[1]]) #append each set of dens to the list of dens (ie, 10000 sets of 5 year's of dens)
sim.dist.2yr[[2]]=as.data.frame(Map('+',sim.dist4[[2]]   ,sim.dist5[[2]]) )#add all the counts together from all 5



writeLines(paste("AOGA den disturbance output for final 2 years" ))
tmp = summary.stats(sim.dist.2yr)
print(tmp, row.names = FALSE)


sink()

#######################
#Get some plots  Trying with the 5 year data


disturbed.late.LevA     = do.call(c, unname(lapply(sim.dist.5yr[[1]],'[[','disturbed.late.LevA'  ))) 
disturbed.post.LevA     = do.call(c, unname(lapply(sim.dist.5yr[[1]],'[[','disturbed.post.LevA'  ))) 
disturbed.LevA.index    = which(disturbed.late.LevA==1 | disturbed.post.LevA==1)

P.Litter.Surv.undist         = do.call(c, unname(lapply(sim.dist.5yr[[1]],'[[','P.Litter.Surv.undist' )))      #ALL dens
P.Litter.Surv.undist.dist    = P.Litter.Surv.undist[disturbed.LevA.index]  #only disturbed dens orig values
P.Litter.Surv.dist           = do.call(c, unname(lapply(sim.dist.5yr[[1]],'[[','P.Litter.Surv.dist'   )))[disturbed.LevA.index]  #only disturbed dens  new values
P.Litter.Surv.combined       = P.Litter.Surv.undist
P.Litter.Surv.combined[disturbed.LevA.index]  = P.Litter.Surv.dist           #create set with final values, using disturbed as needed


#stack undisturbed and disturbed survival values for all SBS
jpeg(paste0(out.path,"litter_survival_all_land_SBS_", insert.time(),".jpg"),w=1000,h=1000)
par(mfcol=c(2,1)) 
hist(P.Litter.Surv.undist         ,ylim=c(0,10),cex.main=2,cex.lab=2,cex.axis=2,freq = F,xlab="Estimated litter survival",ylab="Scaled relative occurrence",main="Undisturbed values \nfor SBS land based dens") #ALL dens
abline(v=.5,col='black',lty=2)
hist(P.Litter.Surv.combined       ,ylim=c(0,10),cex.main=2,cex.lab=2,cex.axis=2,freq = F,xlab="Estimated litter survival",ylab="Scaled relative occurrence",main="Updated values \nfor SBS land based dens") #ALL dens
abline(v=.5,col='black',lty=2)
par(mfrow=c(1,1)) 
dev.off()

#pie chart of total SBS sims, showing proportion of affected LevA dens
jpeg(paste0(out.path,"proportion_levA_all_land_SBS_", insert.time(),".jpg"),w=1500,h=1000)
par(mfrow=c(1,1)) 
all.dens = length(P.Litter.Surv.undist) #something all dens have
levA.dens = length(disturbed.LevA.index)
pie(x=c(all.dens-levA.dens,levA.dens),cex.main=2,cex.lab=2,cex.axis=2,
    labels = "",
    #labels = c(paste0("non-Level A disturbed dens\n",round(1-levA.dens/all.dens,3),"%"),paste0("Level A disturbed dens\n",round(levA.dens/all.dens,3),"%")),
    col=c("white","black"),  main="Proportion of SBS land based dens with Level A disturbance")
text(-.7,.1,paste0("non-Level A disturbed dens\n",round(1-levA.dens/all.dens,3),"%"), pos=4,cex=2)
text(.85,-.075,paste0(    "Level A disturbed dens\n",round(levA.dens/all.dens,3),"%"),pos=4,cex=2)
dev.off()

